return {
  -- Dawn Body module
    {   
        Name = "Dawn",
        Parent = "Root",

        Renderable = {
            Type = "RenderableModel",
            Body = "DAWN",
            Geometry = {
                Type = "MultiModelGeometry",
                GeometryFile = "${OPENSPACE_DATA}/scene/dawn/obj/mainbodydawn.obj",
            },
            Textures = {
                Type = "simple",
                Color = "textures/gray.png",
            },
            Rotation = {
                Source = "DAWN_SPACECRAFT",
                Destination = "GALACTIC"
            },
            StartTime = "2007 SEP 27 08:15:00",
            EndTime = "2012 SEP 12 23:57:00"
        },
        Ephemeris = {
            Type = "Spice",
            Body = "DAWN",
            Observer = "SUN",
            Kernels = {
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_ref_070926-150201_070829.bsp",
                
                --ik
                "${OPENSPACE_DATA}/spice/DawnKernels/ik/dawn_fc_v10.ti",
                
                "${OPENSPACE_DATA}/spice/de430_1850-2150.bsp",
                -- SPK
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/sb_ceres_110211.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/sb_ceres_140724.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/sb_vesta_071107.bsp",

                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_070927_070930_081218_v1.bsp",
            --[["${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_070930_071201_081218_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_071201_080205_081218_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_080205_080325_081218_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_080325_080503_081218_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_080503_080601_081218_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_080601_080718_081218_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_080718_080910_081218_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_080910_081022_090218_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_081022_081109_090218_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_081109_090228_090306_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_090228_090501_090702_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_090501_090801_090916_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_090801_090915_090923_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_090915_091201_091202_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_091201_100208_100209_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_100208_100316_100323_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_100316_100413_100422_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_100413_100622_100830_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_100622_100824_100830_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_100824_101130_101202_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_101130_110201_110201_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_110201_110328_110328_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_110328_110419_110420_v1.bsp",--]]
                                                          
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_110416_110802_110913_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_110802_110831_110922_v1.bsp",
            --[["${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_110831_110928_111221_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_110928_111102_120615_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_111102_111210_120618_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_111211_120501_120620_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_120501_120611_120625_v1.bsp",
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_120611_120724_121101_v1.bsp",--]]
                "${OPENSPACE_DATA}/spice/DawnKernels/spk/dawn_rec_120724_120913_121213_v1.bsp",

                --PCK
                --"${OPENSPACE_DATA}/spice/DawnKernels/pck/dawn_vesta_v06.tpc",
                --"${OPENSPACE_DATA}/spice/DawnKernels/pck/dawn_ceres_v01.tpc",
                --"${OPENSPACE_DATA}/spice/DawnKernels/pck/pck00008.tpc",

                -- FK
                "${OPENSPACE_DATA}/spice/DawnKernels/fk/dawn_vesta_v00.tf",
                "${OPENSPACE_DATA}/spice/DawnKernels/fk/dawn_v12.tf",

                --SCLK
                "${OPENSPACE_DATA}/spice/DawnKernels/sclk/dawn_203_sclkscet_00039.tsc",

                -- CK
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111226_120101.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120102_120108.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120109_120115.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120116_120122.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120123_120129.bc",

                -- all space craft CK files, ~10 gb
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120123_120129.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_070927_070930.bc",
            --[["${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071001_071007.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071008_071014_v2.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071015_071021.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071022_071028_v2.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071029_071104.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071105_071111.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071112_071118.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071119_071125.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071126_071202.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071203_071209.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071210_071216.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071217_071223.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071224_071230.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_071231_080106.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080107_080113.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080114_080120.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080121_080127.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080128_080203.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080204_080210.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080211_080217.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080218_080224.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080225_080302.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080303_080309.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080310_080316.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080317_080323.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080324_080330.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080331_080406.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080407_080413.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080414_080420.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080421_080427.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080428_080504.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080505_080511.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080512_080518.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080519_080525.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080526_080601.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080602_080608.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080609_080615.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080616_080622.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080623_080629.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080630_080706.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080707_080713.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080714_080720.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080721_080727.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080728_080803.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080804_080810.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080811_080817.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080818_080824.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080825_080831.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080901_080907.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080908_080914.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080915_080921.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080922_080928.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_080929_081005.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081006_081012.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081013_081019.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081020_081026.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081027_081102.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081103_081109.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081110_081116.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081117_081123.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081124_081130.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081201_081207.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081208_081214.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081215_081221.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081222_081228.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_081229_090104.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090105_090111.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090112_090118.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090119_090125.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090126_090201.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090202_090208.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090209_090215.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090216_090222.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090223_090301.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090302_090308.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090309_090315.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090316_090322.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090323_090329.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090330_090405.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090406_090412.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090413_090419.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090420_090426.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090427_090503.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090504_090510.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090511_090517.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090518_090524.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090525_090531.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090601_090607.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090608_090614.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090615_090621.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090622_090628.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090629_090705.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090706_090712.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090713_090719.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090720_090726.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090727_090802.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090803_090809.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090810_090816.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090817_090823.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090824_090830.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090831_090906.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090907_090913.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090914_090920.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090921_090927.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_090928_091004.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091005_091011.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091012_091018.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091019_091025.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091026_091101.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091102_091108.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091109_091115.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091116_091122.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091123_091129.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091130_091206.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091207_091213.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091214_091220.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091221_091227.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_091228_100103.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100104_100110_v2.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100111_100117_v2.bc",--]]
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100118_100124.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100125_100131.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100201_100207.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100208_100214.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100215_100221.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100222_100228.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100301_100307.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100308_100314.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100315_100321.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100322_100328.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100329_100404.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100405_100411.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100412_100418.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100419_100425.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100426_100502.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100503_100509.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100510_100516.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100517_100523.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100524_100530.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100531_100606.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100607_100613.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100614_100620.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100621_100627.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100628_100704.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100705_100711.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100712_100718.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100719_100725.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100726_100801.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100802_100808.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100809_100815.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100816_100822.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100823_100829.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100830_100905.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100906_100912.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100913_100919.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100920_100926.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_100927_101003.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101004_101010.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101011_101017.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101018_101024.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101025_101031.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101101_101107.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101108_101114.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101115_101121.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101122_101128.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101129_101205.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101206_101212.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101213_101219.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101220_101226.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_101227_110102.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110103_110109.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110110_110116.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110117_110123.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110124_110130.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110131_110206.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110207_110213.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110214_110220.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110221_110227.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110228_110306.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110307_110313.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110314_110320.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110321_110327.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110328_110403.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110404_110410.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110411_110417.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110418_110424.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110425_110501.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110502_110508.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110509_110515.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110516_110522.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110523_110529.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110530_110605.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110606_110612.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110613_110619.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110620_110626.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110627_110703.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110704_110710.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110711_110717.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110718_110724.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110725_110731.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110801_110807.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110808_110814.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110815_110821.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110822_110828.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110829_110904.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110905_110911.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110912_110918.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110919_110925.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_110926_111002.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111003_111009.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111010_111016.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111017_111023.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111024_111030.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111031_111106.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111107_111113.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111114_111120.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111121_111127.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111128_111204.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111205_111211.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111212_111218.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111219_111225.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_111226_120101.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120102_120108.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120109_120115.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120116_120122.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120123_120129.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120130_120205.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120206_120212.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120213_120219.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120220_120226.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120227_120304.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120305_120311.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120312_120318.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120319_120325.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120326_120401.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120402_120408.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120409_120415.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120416_120422.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120423_120429.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120430_120506.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120507_120513.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120514_120520.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120521_120527.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120528_120603.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120604_120610.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120611_120617.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120618_120624.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120625_120701.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120702_120708.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120709_120715.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120716_120722.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120723_120729.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120730_120805.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120806_120812.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120813_120819.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120820_120826.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120827_120902.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120903_120909.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_120910_120916.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_f2_3942xxxxx.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_pred_da028b_00_eu.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sc_pred_dc041a_00.bc",

                -- Solar array rotation kernels ~ 2gb
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_070927_070930.bc",
            --[["${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071001_071007.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071008_071014.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071015_071021.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071022_071028_v2.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071029_071104.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071105_071111.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071112_071118.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071119_071125.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071126_071202.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071203_071209.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071210_071216.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071217_071223.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071224_071230.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_071231_080106.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080107_080113.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080114_080120.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080121_080127.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080128_080203.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080204_080210.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080211_080217.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080218_080224.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080225_080302.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080303_080309.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080310_080316.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080317_080323.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080324_080330.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080331_080406.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080407_080413.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080414_080420.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080421_080427.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080428_080504.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080505_080511.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080512_080518.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080519_080525.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080526_080601.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080602_080608.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080609_080615.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080616_080622.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080623_080629.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080630_080706.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080707_080713.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080714_080720.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080721_080727.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080728_080803.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080804_080810.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080811_080817.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080818_080824.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080825_080831.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080901_080907.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080908_080914.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080915_080921.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080922_080928.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_080929_081005.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081006_081012.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081013_081019.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081020_081026.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081027_081102.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081103_081109.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081110_081116.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081117_081123.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081124_081130.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081201_081207.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081208_081214.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081215_081221.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081222_081228.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_081229_090104.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090105_090111.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090112_090118.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090119_090125.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090126_090201.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090202_090208.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090209_090215.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090216_090222.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090223_090301.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090302_090308.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090309_090315.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090316_090322.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090323_090329.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090330_090405.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090406_090412.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090413_090419.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090420_090426.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090427_090503.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090504_090510.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090511_090517.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090518_090524.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090525_090531.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090601_090607.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090608_090614.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090615_090621.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090622_090628.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090629_090705.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090706_090712.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090713_090719.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090720_090726.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090727_090802.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090803_090809.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090810_090816.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090817_090823.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090824_090830.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090831_090906.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090907_090913.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090914_090920.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090921_090927.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_090928_091004.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091005_091011.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091012_091018.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091019_091025.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091026_091101.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091102_091108.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091109_091115.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091116_091122.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091123_091129.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091130_091206.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091207_091213.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091214_091220.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091221_091227.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_091228_100103.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100104_100110_v2.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100111_100117_v2.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100118_100124.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100125_100131.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100201_100207.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100208_100214.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100215_100221.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100222_100228.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100301_100307.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100308_100314.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100315_100321.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100322_100328.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100329_100404.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100405_100411.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100412_100418.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100419_100425.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100426_100502.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100503_100509.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100510_100516.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100517_100523.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100524_100530.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100531_100606.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100607_100613.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100614_100620.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100621_100627.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100628_100704.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100705_100711.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100712_100718.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100719_100725.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100726_100801.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100802_100808.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100809_100815.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100816_100822.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100823_100829.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100830_100905.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100906_100912.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100913_100919.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100920_100926.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_100927_101003.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101004_101010.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101011_101017.bc", --]]
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101018_101024.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101025_101031.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101101_101107.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101108_101114.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101115_101121.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101122_101128.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101129_101205.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101206_101212.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101213_101219.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101220_101226.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_101227_110102.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110103_110109.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110110_110116.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110117_110123.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110124_110130.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110131_110206.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110207_110213.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110214_110220.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110221_110227.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110228_110306.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110307_110313.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110314_110320.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110321_110327.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110328_110403.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110404_110410.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110411_110417.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110418_110424.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110425_110501.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110502_110508.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110509_110515.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110516_110522.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110523_110529.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110530_110605.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110606_110612.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110613_110619.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110620_110626.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110627_110703.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110704_110710.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110711_110717.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110718_110724.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110725_110731.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110801_110807.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110808_110814.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110815_110821.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110822_110828.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110829_110904.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110905_110911.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110912_110918.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110919_110925.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_110926_111002.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111003_111009.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111010_111016.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111017_111023.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111024_111030.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111031_111106.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111107_111113.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111114_111120.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111121_111127.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111128_111204.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111205_111211.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111212_111218.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111219_111225.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_111226_120101.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120102_120108.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120109_120115.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120116_120122.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120123_120129.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120130_120205.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120206_120212.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120213_120219.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120220_120226.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120227_120304.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120305_120311.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120312_120318.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120319_120325.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120326_120401.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120402_120408.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120409_120415.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120416_120422.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120423_120429.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120430_120506.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120507_120513.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120514_120520.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120521_120527.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120528_120603.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120604_120610.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120611_120617.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120618_120624.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120625_120701.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120702_120708.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120709_120715.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120716_120722.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120723_120729.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120730_120805.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120806_120812.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120813_120819.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120820_120826.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120827_120902.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120903_120909.bc",
                "${OPENSPACE_DATA}/spice/DawnKernels/ck/dawn_sa_120910_120916.bc",
            }
        }
    },

     -- Dawn Solar Array module 1
    {   
        Name = "DawnSolar1",
        Parent = "Dawn", 
        Renderable = {
            Type = "RenderableModel",
            Body = "DAWN",
            Geometry = {
                Type = "MultiModelGeometry",
                GeometryFile = "${OPENSPACE_DATA}/scene/dawn/obj/solarpanelleft.obj",
            },
            Textures = {
                Type = "simple",
                Color = "textures/gray.png",
            },
            Rotation = {
                Source = "DAWN_SA-Y",
                Destination = "GALACTIC"
            },
        },
    },

     -- Dawn Solar Array module 2
    {   
        Name = "DawnSolar2",
        Parent = "Dawn", 

        Renderable = {
            Type = "RenderableModel",
            Body = "DAWN",
            Geometry = {
                Type = "MultiModelGeometry",
                GeometryFile = "${OPENSPACE_DATA}/scene/dawn/obj/solarpanelright.obj",
            },
            Textures = {
                Type = "simple",
                Color = "textures/gray.png",
            },
            Rotation = {
                Source = "DAWN_SA+Y",
                Destination = "GALACTIC"
            },

            StartTime = "2007 SEP 27 08:15:00",
            EndTime = "2012 SEP 12 12:00:00"
        },
    },

        -- Dawn Trail Module
   --[[ {   
        Name = "DawnTrail1",
        Parent = "Root",
        Renderable = {
            Type = "RenderableTrail",
            Body = "DAWN",
            Frame = "GALACTIC",
            Observer = "SUN",
            -- 3 Dummy values for compilation:
            TropicalOrbitPeriod = 10000.0,
            EarthOrbitRatio = 1,
            DayLength = 50,
            -- End of Dummy values
            RGB = { 0.35, 0.2, 0.45 },
            Textures = {
                Type = "simple",
                Color = "textures/glare.png"
            },  
            StartTime = "2007 SEP 26 13:28:00",
            EndTime = "2012 SEP 12 12:00:00"
        },
        GuiName = "DawnTrail"
    },--]]
            -- Dawn Trail Module
    {   
        Name = "DawnTrail2",
        Parent = "SolarSystemBarycenter",
        Renderable = {
            Type = "RenderableTrailTrajectory",
            Translation = {
                Type = "SpiceTranslation",
                Body = "DAWN",
                Observer = "SUN",
            },
            Color = { 0.7, 0.4, 0.9 },
            StartTime = "2007 SEP 26 13:28:00",
            EndTime = "2012 SEP 12 12:00:00",
            SampleInterval = 3600 * 24
        },
    },
 --
--          -- Dawn Trail Module
 --   {   
 --       Name = "DawnTrail3",
 --       Parent = "Vesta",
--      Renderable = {
 --           Type = "RenderableTrail",
 --           Body = "DAWN",
--          Frame = "GALACTIC",
--          Observer = "VESTA",
--          -- 3 Dummy values for compilation:
--          TropicalOrbitPeriod = 100000.0,
 --           EarthOrbitRatio = 1,
 --           DayLength = 100,
--          -- End of Dummy values
--          RGB = { 0.3, 0.4, 0.9 },
--          Textures = {
 --               Type = "simple",
--              Color = "textures/glare.png"
 --           },    
--          StartTime = "2011 JUL 20 00:00:00",
--          EndTime = "2012 AUG 25 12:00:00"
--      },
--      GuiName = "DawnTrail"
 --   },

     -- DawnFov 1
    {   
        Name = "Dawn_framing_camera_1",
        Parent = "Dawn",
        Renderable = {
            Type  = "RenderableFov",
            Body  = "DAWN",
            Frame = "GALACTIC",
            RGB   = { 0.8, 0.7, 0.7 },
            Textures = {
                Type  = "simple",
                Color = "textures/glare_blue.png",
                -- need to add different texture
            },
            Instrument = {
                Name       = "DAWN_FC1",
                Method     = "ELLIPSOID",
                Aberration = "NONE",
            },
            PotentialTargets = {
                "VESTA",
                "CERES"
            }
        },
    },

     -- DawnFov 1
    {   
        Name = "Dawn_framing_camera_2",
        Parent = "Dawn",
        Renderable = {
            Type  = "RenderableFov",
            Body  = "DAWN",
            Frame = "GALACTIC",
            RGB   = { 0.8, 0.7, 0.7 },
            Textures = {
                Type  = "simple",
                Color = "textures/glare_blue.png",
                -- need to add different texture
            },
            Instrument = { 
                Name       = "DAWN_FC2",
                Method     = "ELLIPSOID",
                Aberration = "NONE",
            },
            PotentialTargets = {
                "VESTA",
                "CERES"
            }
        },
    },
}
